---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-next dev

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **HMR反映時間**: 具体的な数値の根拠なし
  2. **子プロセスタイムアウトデフォルト値**: 環境変数のデフォルト値は確認済みだが、実際の挙動は未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/cli/next-dev.ts` - next devコマンドのメイン実装
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント、Commanderによるコマンド定義
- E-03: `packages/next/src/lib/bundler.ts` - バンドラー選択ロジック
- E-04: `packages/next/src/server/lib/start-server.ts` - サーバー起動処理
- E-05: `packages/next/src/telemetry/storage.ts` - テレメトリストレージ
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextDevOptions型は12のプロパティを持つ | E-01 (42-58行目) | ○ |
| C-02 | デフォルトバンドラーはTurbopack | E-03 (74-77行目) | ○ |
| C-03 | デフォルトポートは3000 | E-02 (287行目 `.default(3000)`) | ○ |
| C-04 | ポート自動リトライはportSource=defaultの場合のみ | E-01 (237行目) | ○ |
| C-05 | メモリ制限はシステムメモリの50% | E-01 (270-271行目) | ○ |
| C-06 | 子プロセスはforkで起動 | E-01 (303行目) | ○ |
| C-07 | IPCメッセージでnextWorkerReady/nextServerReadyを処理 | E-01 (331-350行目) | ○ |
| C-08 | RESTART_EXIT_CODEで自動再起動 | E-01 (356-371行目) | ○ |
| C-09 | macOSでWATCHPACK_WATCHER_LIMITを20に設定 | E-01 (318-319行目) | ○ |
| C-10 | SIGINT/SIGTERMハンドラが登録される | E-01 (164-165行目) | ○ |
| C-11 | 子プロセスのexit timeout デフォルトは100ms | E-01 (74-77行目) | ○ |
| C-12 | テレメトリのセッション停止記録 | E-01 (104-138行目) | ○ |
| C-13 | プリフライトでsass/node-sass重複を検出 | E-01 (197-207行目) | ○ |
| C-14 | プリフライトで@next/fontの非推奨検出 | E-01 (214-227行目) | ○ |
| C-15 | HTTPS自己署名証明書の生成 | E-01 (380-406行目) | ○ |
| C-16 | devコマンドはisDefault: trueで設定 | E-02 (262行目) | ○ |
| C-17 | バンドラー排他制御あり | E-03 (65-72行目) | ○ |
| C-18 | CPUプロファイル保存処理 | E-01 (155行目) | ○ |
| C-19 | トレースアップロード処理 | E-01 (144-152行目) | ○ |
| C-20 | デバッグポートは親+1 | E-01 (293行目) | ○ |
| C-21 | ソースマップはデフォルト有効 | E-01 (279-283行目) | ○ |
| C-22 | 開発オーバーレイ等6つの関連画面 | E-07 | ○ |
| C-23 | NODE_ENVはdevelopmentに設定 | E-02 (71行目) | ○ |
| C-24 | HMR反映時間は数百ミリ秒程度 | **根拠なし** | △ |
| C-25 | HTTPS証明書生成にはOS権限が必要な場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- HMR反映時間の数値は公式ドキュメントや性能テスト結果に基づくべきだが、コードからは具体的な数値を確認できなかった
  - 候補：Next.js公式ドキュメント / Turbopackベンチマーク結果 / 実測値
- HTTPS証明書生成時のOS権限要件はmkcert.tsの実装に依存するが、OS固有の動作であり網羅的な確認が困難
  - 候補：mkcert.tsの実装確認 / OS別の権限ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: パフォーマンス要件のHMR反映時間は一般的な推定値であり、環境やプロジェクトサイズにより大きく異なる
- 0: バンドラー選択のデフォルト動作（Turbopack）は今後のバージョンで変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] NextDevOptionsの全パラメータが入力仕様に反映されているか
- [ ] 子プロセスのIPCメッセージの種類が網羅されているか
- [ ] シグナルハンドリングの挙動がコードと一致しているか
- [ ] 関連画面マッピングが画面機能マッピング.csvと整合しているか
